
* Bishops Puzzle Solver Program v1.1
* Written May 17, 1993 (in exasperation!)
* Copyright 1993 by Scott Worley  CIS 76066,1352

* setup
setcancel(.f.)
set cursor off
clear screen

* intro message
text
                           Bishops Puzzle Solver v1.1

This program determines, and visually presents, the shortest possible solution
to the "Bishops Puzzle" found in Virgin/Trilobyte's landmark multimedia CD-ROM
game "The 7th Guest".  Note that only the solution for the black squares is
presented, simply flip the solution over 180 degrees for the white squares.

I wrote this program because I was really stuck on this little conundrum.  It
is not "intuitive", and it requires a LOT of trial and error.  Computers excel
at exhaustive procedures that would normally bore a person quickly.

The program is simple enough: from the starting position it determines all the
possible first moves, and using the first moves it determines all the possible
second moves, and so on, until it encounters the solution.  This method ensures
a shortest possible solution.  Also, the program discards board configurations
it has previously encountered to avoid backtracking and going in circles.


                             PRESS ANY KEY TO BEGIN


                 This program is copyright 1993 by Scott Worley
     "The 7th Guest" is a trademark and copyright of Virgin Games/Trilobyte
endtext
inkey(0)
@ 08,00 clear to 16,79
@ 19,29 say '     WORKING ...      '

* draw gameboard
@ 10,29 say ''
@ 11,29 say '      '
@ 12,29 say '         '
@ 13,29 say '      '
@ 14,29 say '         '
@ 15,29 say ''

* The board positions       Movement/control directions
*       1   2
*     3   4   5                       1   2
*       6   7                           x
*     8   9  10                       3   4

* this array is the heart of the movement logic: it defines where pieces are,
* where they can move, and where they block movement.  Each element in the
* array represents a piece at a given place on the board, and each of the
* 10 characters in the array reflect the status of the other board positions:
* space=piece itself, 0=no move or control, 1-4=move/control in that direction
declare mask[10]
mask[1] =' 034004004'
mask[2] ='0 03430300'
mask[3] ='20 0040040'
mask[4] ='120 034304'
mask[5] ='0100 03030'
mask[6] ='02120 0340'
mask[7] ='100120 034'
mask[8] ='0202020 00'
mask[9] ='00102120 0'
mask[10]='100100100 '

* initial and target boards: 0=no piece, 1=white bishop, 2=black bishop
start ='0020100201'
target='0010200102'

* create an indexed temporary database to hold board configurations
erase $boards$.dbf
create $boards$
append blank
replace FIELD_NAME with 'TBOARD', FIELD_TYPE with 'C', FIELD_LEN with 10
append blank
replace FIELD_NAME with 'LEVEL',  FIELD_TYPE with 'N', FIELD_LEN with 2
append blank
replace FIELD_NAME with 'LINK',   FIELD_TYPE with 'N', FIELD_LEN with 3
append blank
replace FIELD_NAME with 'W1MOVE', FIELD_TYPE with 'C', FIELD_LEN with 4
append blank
replace FIELD_NAME with 'W2MOVE', FIELD_TYPE with 'C', FIELD_LEN with 4
append blank
replace FIELD_NAME with 'B1MOVE', FIELD_TYPE with 'C', FIELD_LEN with 4
append blank
replace FIELD_NAME with 'B2MOVE', FIELD_TYPE with 'C', FIELD_LEN with 4
use
erase boards.dbf
create boards from $boards$
erase $boards$.dbf
use boards
index on TBOARD to boards

* add initial board and possible moves to database to start process
append blank
replace TBOARD with start, ;
        W1MOVE with '6', W2MOVE with '6', ;
        B1MOVE with '5', B2MOVE with '5'

* display initial board
depth=1
board=TBOARD
drawboard()
@ 16,35 say 'Depth:  1'

* main search loop
do while .t.

   * read current record as the one being researched
   board=TBOARD
   parent=recno()

   * exhaust all possible moves for current board
   if !empty(W1MOVE)
      from=at('1',board)
      to=val(left(W1MOVE,1))+1
      replace W1MOVE with substr(W1MOVE,2)
   elseif !empty(W2MOVE)
      from=rat('1',board)
      to=val(left(W2MOVE,1))+1
      replace W2MOVE with substr(W2MOVE,2)
   elseif !empty(B1MOVE)
      from=at('2',board)
      to=val(left(B1MOVE,1))+1
      replace B1MOVE with substr(B1MOVE,2)
   elseif !empty(B2MOVE)
      from=rat('2',board)
      to=val(left(B2MOVE,1))+1
      replace B2MOVE with substr(B2MOVE,2)
   else
      * advance to next board
      go parent+1
      depth=LEVEL+1
      if eof()
         * out of moves, so there must be no solution...
         @ 19,26 say 'NO SOLUTION!?  ANY KEY QUITS'
         inkey(0)
         * clean up
         use
         erase boards.dbf
         erase boards.ntx
         set cursor on
         clear screen
         quit
      endif
      @ 16,42 say str(depth,2)
      loop
   endif

   * build the new board configuration based on move
   piece=subs(board,from,1)
   board=left(board,from-1)+'0'+substr(board,from+1)
   board=left(board,to-1)+piece+substr(board,to+1)
   drawboard()

   * look to see if the board is already being researched
   seek board
   if !found()
      * figure locations of pieces in board string
      w1= at('1',board)
      w2=rat('1',board)
      b1= at('2',board)
      b2=rat('2',board)
      * figure all possible moves for all pieces using array
      store '' to w1m,w2m,b1m,b2m
      for i=1 to 10
        if subs(mask[b1],i,1)+subs(mask[b2],i,1)='00'
          v=subs(mask[w1],i,1)
          if v>'0'.and.(subs(mask[w1],w2,1)#v.or.((v<'3'.and.w2<i).or.(v>'2'.and.w2>i)))
             w1m=w1m+str(i-1,1)
          endif
          v=subs(mask[w2],i,1)
          if v>'0'.and.(subs(mask[w2],w1,1)#v.or.((v<'3'.and.w1<i).or.(v>'2'.and.w1>i)))
             w2m=w2m+str(i-1,1)
          endif
        endif
        if subs(mask[w1],i,1)+subs(mask[w2],i,1)='00'
          v=subs(mask[b1],i,1)
          if v>'0'.and.(subs(mask[b1],b2,1)#v.or.((v<'3'.and.b2<i).or.(v>'2'.and.b2>i)))
             b1m=b1m+str(i-1,1)
          endif
          v=subs(mask[b2],i,1)
          if v>'0'.and.(subs(mask[b2],b1,1)#v.or.((v<'3'.and.b1<i).or.(v>'2'.and.b1>i)))
             b2m=b2m+str(i-1,1)
          endif
        endif
      next i

      * add board to database with link pointing to parent
      append blank
      replace TBOARD with board, ;
              LEVEL with depth, LINK with parent, ;
              W1MOVE with w1m, W2MOVE with w2m, ;
              B1MOVE with b1m, B2MOVE with b2m

      if board=target
         * got it!  go show it
         exit
      endif

   endif

   go parent

enddo

* the links go BACKWARD at this point, so this loop switches them the other
* way as it follows it back, so the solution can be shown going FORWARD
do while recno()#1
   child=recno()
   go parent
   parent=LINK
   replace LINK with child
enddo

* display the solution
@ 19,21 say 'SHOWING SOLUTION, PRESS <ESC> TO QUIT'
@ 16,35 say 'Move#:   '
depth=0
do while .t.
   @ 16,42 say str(depth,2)
   board=TBOARD
   drawboard()
   inkey(1)
   if lastkey()=27
      exit
   endif
   if board=target
      go 1
      depth=0
   else
      go LINK
      depth=depth+1
   endif
enddo

* clean up
use
erase boards.dbf
erase boards.ntx
set cursor on
clear screen
quit


* a function that draws pieces on gameboard using the board string
function drawboard
private i,j,k,pos
for i=1 to 10
   pos=substr(' WB',val(substr(board,i,1))+1,1)
   j=if(i<6,i,i-5)
   k=if(i<6,0,2)
   if j=1
      @ 11+k,36 say pos
   elseif j=2
      @ 11+k,42 say pos
   elseif j=3
      @ 12+k,33 say pos
   elseif j=4
      @ 12+k,39 say pos
   elseif j=5
      @ 12+k,45 say pos
   endif
next i
return(.t.)
